/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.itemblock;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.objects.fluids.capability.FluidWhitelistHandlerComplex;
import net.dries007.tfc.objects.items.itemblock.ItemBlockTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.ICalendarFormatted;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public class ItemBlockBarrel
extends ItemBlockTFC {
    public ItemBlockBarrel(Block block) {
        super(block);
        OreDictionaryHelper.register((Item)this, "barrel");
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IFluidHandler barrelCap;
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && (barrelCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && barrelCap.drain(1, false) == null) {
            Fluid fluid;
            BlockPos fluidPos = pos.func_177972_a(facing);
            IBlockState state = worldIn.func_180495_p(fluidPos);
            IFluidHandler handler = FluidUtil.getFluidHandler((World)worldIn, (BlockPos)fluidPos, (EnumFacing)facing);
            if (handler != null && handler.drain(1000, false) != null && (fluid = handler.drain(1000, false).getFluid()).getTemperature() < 500) {
                boolean canCreateSources = false;
                if (state.func_177230_c() instanceof BlockFluidClassic) {
                    BlockFluidClassic fluidblock = (BlockFluidClassic)worldIn.func_180495_p(fluidPos).func_177230_c();
                    canCreateSources = (Boolean)ObfuscationReflectionHelper.getPrivateValue(BlockFluidClassic.class, (Object)fluidblock, (String)"canCreateSources");
                } else if (state.func_177230_c() instanceof BlockLiquid) {
                    canCreateSources = ForgeEventFactory.canCreateFluidSource((World)worldIn, (BlockPos)fluidPos, (IBlockState)state, (state.func_185904_a() == Material.field_151586_h ? 1 : 0) != 0);
                }
                FluidStack fluidStack = handler.drain(1000, true);
                if (canCreateSources && fluidStack != null) {
                    fluidStack.amount = ConfigTFC.Devices.BARREL.tank;
                }
                barrelCap.fill(fluidStack, true);
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        IFluidHandler barrelCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        return barrelCap != null && barrelCap.drain(1, false) != null ? super.func_77658_a() + ".sealed" : super.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IFluidHandler barrelCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (barrelCap instanceof ItemBarrelFluidHandler && ((ItemBarrelFluidHandler)barrelCap).getBarrelContents() != null) {
            FluidStack fluidStack = barrelCap.drain(Integer.MAX_VALUE, false);
            ItemStackHandler stackHandler = new ItemStackHandler(3);
            stackHandler.deserializeNBT(((ItemBarrelFluidHandler)barrelCap).getBarrelContents().func_74775_l("inventory"));
            ItemStack inventory = stackHandler.getStackInSlot(2);
            if (fluidStack == null || fluidStack.amount == 0) {
                if (inventory.func_190926_b()) {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tfc.tooltip.barrel_empty", (Object[])new Object[0]));
                } else {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tfc.tooltip.barrel_item", (Object[])new Object[]{inventory.func_190916_E(), inventory.func_77973_b().func_77653_i(inventory)}));
                }
            } else {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tfc.tooltip.barrel_fluid", (Object[])new Object[]{fluidStack.amount, fluidStack.getLocalizedName()}));
                if (!inventory.func_190926_b()) {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tfc.tooltip.barrel_item_in_fluid", (Object[])new Object[]{inventory.func_190916_E(), inventory.func_77973_b().func_77653_i(inventory)}));
                }
            }
            String formattedDate = ICalendarFormatted.getTimeAndDate(stack.func_77978_p().func_74763_f("sealedCalendarTick"), CalendarTFC.CALENDAR_TIME.getDaysInMonth());
            tooltip.add(TextFormatting.DARK_GREEN + new TextComponentTranslation("waila.tfc.barrel.sealed", new Object[]{formattedDate}).func_150254_d());
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        RayTraceResult rayTrace;
        IFluidHandler barrelCap;
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && (barrelCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && barrelCap.drain(1, false) == null && (rayTrace = this.func_77621_a(worldIn, player, true)) != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTrace.func_178782_a();
            IBlockState state = worldIn.func_180495_p(pos);
            IFluidHandler handler = FluidUtil.getFluidHandler((World)worldIn, (BlockPos)pos, (EnumFacing)rayTrace.field_178784_b);
            if (handler != null && handler.drain(1000, false) != null) {
                FluidTank tank = new FluidTank(ConfigTFC.Devices.BARREL.tank);
                boolean canCreateSources = false;
                if (state.func_177230_c() instanceof BlockFluidClassic) {
                    BlockFluidClassic fluidblock = (BlockFluidClassic)worldIn.func_180495_p(pos).func_177230_c();
                    canCreateSources = (Boolean)ObfuscationReflectionHelper.getPrivateValue(BlockFluidClassic.class, (Object)fluidblock, (String)"canCreateSources");
                } else if (state.func_177230_c() instanceof BlockLiquid) {
                    canCreateSources = ForgeEventFactory.canCreateFluidSource((World)worldIn, (BlockPos)pos, (IBlockState)state, (state.func_185904_a() == Material.field_151586_h ? 1 : 0) != 0);
                }
                FluidStack fluidStack = handler.drain(1000, true);
                if (canCreateSources && fluidStack != null) {
                    fluidStack.amount = ConfigTFC.Devices.BARREL.tank;
                }
                barrelCap.fill(fluidStack, true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
            }
        }
        return super.func_77659_a(worldIn, player, hand);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ItemBarrelFluidHandler(stack);
    }

    public static class ItemBarrelFluidHandler
    extends FluidWhitelistHandlerComplex {
        protected ItemBarrelFluidHandler(@Nonnull ItemStack container) {
            super(container, ConfigTFC.Devices.BARREL.tank, ConfigTFC.Devices.BARREL.fluidWhitelist);
        }

        @Override
        public boolean canFillFluidType(FluidStack fluid) {
            return super.canFillFluidType(fluid) || BarrelRecipe.isBarrelFluid(fluid);
        }

        public void setBarrelContents(@Nullable FluidStack fluidStack, @Nullable NBTTagCompound inventoryTag, @Nullable NBTTagList surplusTag, long sealedTick, long sealedCalendarTick) {
            this.fill(fluidStack, true);
            NBTTagCompound nbt = this.container.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if (inventoryTag != null) {
                nbt.func_74782_a("inventory", (NBTBase)inventoryTag);
            }
            if (surplusTag != null) {
                nbt.func_74782_a("surplus", (NBTBase)surplusTag);
            }
            nbt.func_74772_a("sealedTick", sealedTick);
            nbt.func_74772_a("sealedCalendarTick", sealedCalendarTick);
            this.container.func_77982_d(nbt);
        }

        @Nullable
        public NBTTagCompound getBarrelContents() {
            return this.container.func_77978_p();
        }

        protected void setFluid(@Nonnull FluidStack fluid) {
            if (!this.container.func_77942_o()) {
                this.container.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbt = this.container.func_77978_p();
            nbt.func_74772_a("sealedTick", CalendarTFC.PLAYER_TIME.getTicks());
            nbt.func_74772_a("sealedCalendarTick", CalendarTFC.CALENDAR_TIME.getTicks());
            this.container.func_77982_d(nbt);
            super.setFluid(fluid);
        }

        protected void setContainerToEmpty() {
            if (this.container.func_77978_p() != null) {
                super.setContainerToEmpty();
                if (!this.container.func_77978_p().func_74764_b("inventory") && !this.container.func_77978_p().func_74764_b("surplus")) {
                    this.container.func_77982_d(null);
                }
            }
        }
    }
}

